'2ndWindow.bas
'Created by Richard Ryles April 2003
'Setting up Our Second Game Window.
'Take your time reading through the comments about this window.
'At this point all we are trying to do is set up a basic window
'with a bitmap background and some statictext above the graphicbox.

'I.  Window Setup
nomainwin 'keeps the mainwindow from showing, put an apostrophe in front of this
                'command to see what the main window looks like.

WindowWidth = 500:WindowHeight =320 'The size in pixles that our window will be.
UpperLeftX=Int((DisplayWidth-WindowWidth)/2)    'these two lines of code center our
UpperLeftY=Int((DisplayHeight-WindowHeight)/2)  'window in the middle of our screen


graphicbox #game.g, 0, 20, 500, 300  'dropped down 20 pixels from the top
                                                    'this graphicbox is where all of our animation will take place
                                                    'sprites can only be drawn in a graphicbox or a graphics window.

statictext #game.st, "You can put a score here",0,0,200,18 'adding the statictext along the top

                                'each control has to have it's own unique name.  Here the statictext
                                'belongs to window "game" and it's unique name is "st".  Kinda like our
                                'names except instead of Bob Smith, with Liberty BASIC we would say that
                                'he is of the Smith window and his name is Bob, hence, Smith.Bob

'*** Open your window, put your title where it says "1st Game Window"
open "2nd Game Window" for window as #game  'here we are opening a basic window
print #game, "trapclose [quit]"     'this causes the little "X" in the upper right hand corner of the
                                                'window to jump down to the [quit] label in our program and end the program.

'II.  Load Bitmaps
loadbmp "bg", "subBG.bmp"

'III.  Initialize Variables

'IV.  Setup Sprites
    'A.  Set Background
print #game.g, "background bg";     'Now we set the bitmap "bg" that we loaded earlier as
                                                  'the background for our graphic box.

    'B.  Add Sprites to the Window - addsprite

    'C.  Set Initial Location of Sprites - spritexy

   ' D.  Set other Sprite Attributes

'V.  Initialize Timer, set no less than 56
timer 100, [TimerBranch]    'The timer works off of milliseconds.  There are 1000 milliseconds in a second.
                                      'Every 1/10th of a second the program executes the [TimerBranch] no matter
                                      'what else may be happening.  The [TimerBranch] can cause a lot of things to happen.
wait    'Tells the program to stop here until given other instructions.  At this point only the [TimerBranch] is giving
         ' instructions

'VI.  Initialize Keyboard and Mouse Events

'VII.  Timer Branch
[TimerBranch]   'The TimerBranch will have many gosubs when we are finished with our game
gosub [draw]    'At the moment all [draw] is doing is redrawing the background every 1/10th of a second.
wait    'Once again, when the program gets here we do not want it to go any farther, so it waits until told
          'to do something else.

'VIII.  Quit Branch - unloads bitmaps and closes windows
[quit]
'*** Unload all of your bitmaps
    unloadbmp "bg"  'We must unload this to free up the memory we are using.
    close #game  'we close any open windows to also free up memory.
    end     'terminates execution of the program.

            'We must be careful to free up the memory resources we are using.
            'If not our computer will be holding our LB items in memory after we are
            'finished and could cause memory problems until we reboot our machines.

'IX.  Branches called by Mouse and or Keyboard - user entity movement

'X.  Subs Called by Timer Branch
'Sections IX and X will contain the bulk of your programs.  Once you have I through VIII coded
'it will not change much during the couse of your game, usually a line here or a line there.
'But the Subs called by the mouse, keyboard and timer routines are what give your games "action."
'As we go along I'll try to give you some helpful tips in keeping these two areas organized and simplified.

[draw]      'I try to keep the [draw] branch the last one in my programs since it is usually the last
                'branch called by the [TimerBranch]

print #game.g, "drawsprites";   'redraws background and sprites every 1/10th of a second
return  'When a return is encountered, execution is transferred back to the statement immediately after the GOSUB
            'which directed the program to this sub.
